C
C------------------------------------------------------
C
C   Problem:    RD_CSTR
C
C   Date:       22.3.2001
C
C
C------------------------------------------------------
C    
*     INTEGER CONSTANT
      n   = 6
      n_2 = n-2
C
C------------------------------------------------------
C
*     SET OF INDICES
      ISET = 1..n
      ISET2 = 1..n_2
C
C------------------------------------------------------
C
*     TABLE V_Zelle(i), i in ISET
      1   62.4
      2   40.2
      3   40.2
      4   40.2
      5   60.3
      6   19.3
C     
*     TABLE eps(i), i in ISET
      1   0.0211
      2   0.0438
      3   0.0666
      4   0.0438
      5   0.0901
      6   0.1022
C     
*     TABLE vg(i), i in ISET
      1   0.004
      2   0.0078
      3   0.0116
      4   0.0153
      5   0.0171
      6   0.0170
C     
*     TABLE vfl(i), i in ISET
      1   0.0087
      2   0.0087
      3   0.0086
      4   0.0086
      5   0.0086
      6   0.0085       
C     
*     TABLE c_fl_start(i), i in ISET
      1    9.0
      2    3.0
      3   15.0
      4   14.0
      5   17.0
      6   23.0            
C
C------------------------------------------------------
C
*     REAL CONSTANT
      DI = 5.06
      A_Reaktor = 3.1416/4*DI**2
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. concentration variable, if exists (c)
C     3. time variable (t)
C
*     VARIABLE
      KF1, c_fl_ein1, a_rel 
      t_ein, t_aus
      c_fl(i), i in ISET
      t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:

*     FUNCTION dcfl_dt(i), i in ISET    
      KF = KF1*100
      c_fl_ein = c_fl_ein1*10000
      IF ((t.gt.t_ein).and.(t.le.t_aus)) THEN
        c_fl_ein0 = c_fl_ein
      ELSE
        c_fl_ein0 = 0.0
      ENDIF
      IF (i.eq.1) THEN
        V_Rueck1= KF*vg(1)**0.2*a_rel/(1 + 0.01*vg(1)/a_rel)
        dcfl_dt(i) = vfl(1)*A_Reaktor/(1 - eps(1))/V_Zelle(1)*(c_fl(2) - c_fl(1))
     &       - V_Rueck1/(1 - eps(1))/V_Zelle(1)*c_fl(1)
     &       + V_Rueck1/(1 - eps(1))/V_Zelle(1)*c_fl(2)
      ENDIF
      IF ((i.gt.1).and.(i.lt.n)) THEN
        V_RueckI = KF*vg(i)**0.2*a_rel/(1 + 0.01*vg(i)/a_rel)
        V_RueckI_1=KF*vg(i-1)**0.2*a_rel/(1 + 0.01*vg(i-1)/a_rel)
        dcfl_dt(i) = vfl(i)*A_Reaktor/(1 - eps(i))/V_Zelle(i)*(c_fl(i+1)-c_fl(i))
     &       - V_RueckI/(1 - eps(i))/V_Zelle(i)*c_fl(i)
     &       + V_RueckI_1/(1 - eps(i))/V_Zelle(i)*c_fl(i-1)
     &       - V_RueckI_1/(1 - eps(i))/V_Zelle(i)*c_fl(i)
     &       + V_RueckI/(1 - eps(i))/V_Zelle(i)*c_fl(i+1)
      ENDIF
      IF (i.eq.n) THEN
        V_RueckN_1 = KF*vg(i-1)**0.2*a_rel/(1 + 0.01*vg(i-1)/a_rel)
        dcfl_dt(i) = vfl(i)*A_Reaktor/(1 - eps(i))/V_Zelle(i)*(c_fl_ein0 - c_fl(i))
     &       + V_RueckN_1/(1 - eps(i))/V_Zelle(i)*c_fl(i-1)
     &       - V_RueckN_1/(1 - eps(i))/V_Zelle(i)*c_fl(i)
      ENDIF
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION c_fl_0(i), i in ISET
      if (t.lt.1E-7) then
        c_fl_0(i) = c_fl_start(i)
      else
        c_fl_0(i) = c_fl(i) 
      endif
C        
C------------------------------------------------------
C
C   - Fitting criteria:
C     
*     FUNCTION c_fl_aus(i), i in ISET
      c_fl_aus(i)  = c_fl(7-i)
C        
C------------------------------------------------------
C
C   - Constraints:
C     
*     FUNCTION g
      g = t_aus - t_ein - 0.01
C      
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C







