C
C------------------------------------------------------
C
C     Problem:    RATSOL2
C
C     Date:       16.01.00
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      c1, c2, y1, y2, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION y1_t
      a11 = t**2
      a12 = 2 + t
      a21 = 1 + t + t**2
      a22 = 8 - 3*t**2
      b1 = (56 + 141*t + 339*t**2 + t**3/2 + t**4/8)/
     /            (56 - 27*t)
      b2 = (6 + 3*t + 35*t**2/2 - 83*t**3/8)/(1 - t + t**2/4)
      y1_t = c1*(a11*y1 + a12**2*y2 + b1)
C
*     FUNCTION y2_t
      y2_t = c2*(a21**2*y1 + a22**2*y2 + b2) 
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y1_0
      y1_0 = 1
C
*     FUNCTION y2_0
      y2_0 = -1
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION y1_fit
      y1_fit = y1
C
*     FUNCTION y2_fit
      y2_fit = y2
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
