C
C------------------------------------------------------
C
C     Problem:    RATSOL1
C
C     Date:       16.01.00
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      a, y10, y20, y1, y2, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION y1_t
      d = a*(t**2 - 4)
      a11 = 512 + 7040*t + 5152*t**2 - 9996*t**3 - 6860*t**4
      a12 = -768 + 8192*t + 22384*t**2 - 12320*t**3 - 19600*t**4
      a21 = -1024 - 3584*t + 784*t**2 + 5488*t**3 + 2401*t**4
      a22 = -512 - 7552*t - 5152*t**2 + 9996*t**3 + 6860*t**4
      y1_t = (a11**2*y1 + a12**2*y2)/d
C
*     FUNCTION y2_t
      y2_t = (a21**2*y1 + a22**2*y2)/d 
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y1_0
      y1_0 = y10
C
*     FUNCTION y2_0
      y2_0 = y20
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION y1_fit
      y1_fit = y1
C
*     FUNCTION y2_fit
      y2_fit = y2
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
