C
C------------------------------------------------------
C
C     Problem:    RATE_MOD
C
C     Date:       17.12.1999
C
C------------------------------------------------------
C
*     REAL CONSTANT
      b1 = 0.0136
      b6 = 1
      b9 = 0
      b10 = 4.1135
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      b2, b3, b4, b5, b7, b8
      xDBT, yBP, yCHB, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION xDBT_t
      y1 = xDBT
      if (yBP.lt.0.0001) then
        y2 = 0.0001
      else
        y2 = yBP
      endif
      y3 = yCHB
      nom1 = 1 + b8*b7*(1 - y1) + b9*b8*y1 + b7*y1
      nom2 = 1 + b8*b7*(1 - y1) + b9*b8*y1 
      if (y1.gt.0.9999) then
        r11 = 0
      else
        r11 = y2/(1 - y1)
      endif
      r12 = y3/y2
      r1 = b1*(1 - y1)/nom1
      r2 = b2*r1*b7*y1/nom2 
      r3 = b3*r1
      r4 = b4*r2
      r5 = (1 - b3)*r1
      r6 = (1 - b4)*r2
      r7 = b5*r1*r11
      r8 = b6*b2*r7*b7*y1/nom2
      r9 = b10*r7*r12
      r10 = b10*r8*r12
      xDBT_t = r1 + r2
*     FUNCTION yBP_t
      yBP_t = r3 + r4 - r7 - r8 + r9 + r10
C
*     FUNCTION yCHB_t
      yCHB_t = r5 + r6 - r9 - r10 + r7 + r8
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION xDBT_0
      xDBT_0 = 0
C
*     FUNCTION yBP_0
      yBP_0 = 0
C
*     FUNCTION yCHB_0
      yCHB_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION xDBT_fit
      xDBT_fit = xDBT
C
*     FUNCTION yBP_fit
      yBP_fit = yBP
C
*     FUNCTION yCHB_fit
      yCHB_fit = yCHB
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
