C
C------------------------------------------------------
C
C     Problem:  QUINIDIN 
C
C     Date:     03.02.97
C
C------------------------------------------------------
C
*     PARAMETER
      lmax = 8
C
C------------------------------------------------------
C
*     INDEX
      l
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..lmax
C
C------------------------------------------------------
C
*     TABLE dt(i), i IN ind
      1     0.0
      2   288.0
      3   504.0
      4   816.0
      5   816.2
      6  1241.0
      7  1249.0
      8  7897.0
C
*     TABLE D(i), i IN ind
      1   201.0
      2   201.0
      3   201.0
      4   201.0
      5   201.0
      6   201.0
      7   201.0
      8   201.0 
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. concentration variable, if exists (c)
C     3. time variable (t)
C
*     VARIABLE
      F, V, k_a, k_e, t
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION conc
C
      l = 1
      C_a = F*D(1)/V
      C = 0.0
 1000 CONTINUE
      l = l+1
      IF (t.GT.dt(l)) THEN
        exp_a = EXP(-k_a*(dt(l)-dt(l-1)))
        exp_e = EXP(-k_e*(dt(l)-dt(l-1)))
        C = C*exp_e + C_a*k_a/(k_a - k_e)*(exp_e - exp_a)
        C_a = C_a*exp_a + F*D(l)/V
        IF (l.LT.lmax) THEN
          GOTO 1000
        ENDIF
      ENDIF
      l = l-1
      conc = C*EXP(-k_e*(t-dt(l))) + C_a*k_a/(k_a-k_e)
     /      *(EXP(-k_e*(t-dt(l))) - EXP(-k_a*(t-dt(l))))
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G
C      G = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


