C
C------------------------------------------------------
C
C     Problem:    P_IDENT2
C
C     Date:       07.12.2006
C
C------------------------------------------------------
C
*     REAL CONSTANT
      a21 = 1
      b1 = 1
      u1 = 1
      u2 = 1
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. variables identifying solution of corresponding
C        algebraic equations (z)
C     4. concentration variable, if exists (c)
C     5. time variable (t)
C
*     VARIABLE
      a11, a12, a22, b2
      x1, x2, y, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x1_p
      x1_p = -a11*x1 + a12*x2 + b1*u1
C
*     FUNCTION x2_p
      x2_p = a21*x1 - a22*x2 + b2*u2
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     algebraic equations:
C
*     FUNCTION a1
      a1 = y - x1
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x10
      x10 = 1
C
*     FUNCTION x20
      x20 = 1
C
C------------------------------------------------------
C
C   - Initial values for solving systems of algebraic
C     equations (t=0):
C
*     FUNCTION y0
      y0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION y_fit
      y_fit = y
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


