C
C------------------------------------------------------
C
C     Problem:    PYROLYS
C
C     Date:       01.12.2005
C
C------------------------------------------------------
C         
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      A2, A3, A4, A5, A6, E2, E3, E4, E5, E6, alpha, beta
      y1, y2, y3, y4, y5, y6, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION y1_t               
      if (t.le.3600) then
        Temp = 300 + 0.1667*t
      else
        Temp = 900
      endif    
      k2 = A2*exp(-E2/(8.32*Temp))
      k3 = A3*exp(-E3/(8.32*Temp))
      k4 = A4*exp(-E4/(8.32*Temp))
      k5 = A5*exp(-E5/(8.32*Temp))
      k6 = A6*exp(-E6/(8.32*Temp))
      y1t = -k2*y1 + 0.2755*k3*y2
      y1_t = y1t
C
*     FUNCTION y2_t
      y2t = -k3*y2
      y2_t = y2t
C
*     FUNCTION y3_t
      y3t = -k4*y3 + 0.7245*k3*y2
      y3_t = y3t
C
*     FUNCTION y4_t
      y4t = -k5*y4
      y4_t = y4t      
C
*     FUNCTION y5_t
      y5t = beta*k5*y4 - k6*y6
      y5_t = y5t
C
*     FUNCTION y6_t
      y6_t = y1t + y2t + y3t + y4t + y5t
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y1_0
      y1_0 = 0.4913 + 15.6118/alpha
C
*     FUNCTION y2_0
      y2_0 = 0.3387 - 15.6118/alpha
C
*     FUNCTION y3_0
      y3_0 = 0
C
*     FUNCTION y4_0
      y4_0 = 0.1593*(alpha + 80)/alpha
C
*     FUNCTION y5_0
      y5_0 = 0
C
*     FUNCTION y6_0
      y6_0 = 1
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION y1_fit
      y1_fit = y1
C
*     FUNCTION y2_fit
      y2_fit = y2
C
*     FUNCTION y3_fit
      y3_fit = y3
C
*     FUNCTION y4_fit
      y4_fit = y4
C
*     FUNCTION y5_fit
      y5_fit = y5
C
*     FUNCTION y6_fit
      y6_fit = y6
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
