C
C------------------------------------------------------
C
C     Problem:    PYRIDIN
C
C     Date:       17.7.1993
C
C------------------------------------------------------
C
*     REAL CONSTANT
      P11 = 1.0
C
C------------------------------------------------------
C
*     SET OF INDICES
      INDP=1..10
      INDY=1..6
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      P(I), I IN INDP
      A, B, C, D, E, F, G, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION AP
      AP=-P(1)*A + P(9)*B
C
*     FUNCTION BP
      BP=P(1)*A - P(2)*B - P(3)*C*B + P(7)*D - P(9)*B + P(10)*D*F
C
*     FUNCTION CP
      CP=P(2)*B - P(3)*C*B - 2.0*P(4)*C**2 - P(6)*C + P(8)*E
     /     + P(10)*D*F + 2.0*P11*E*F
*     FUNCTION DP
      DP=P(3)*C*B - P(5)*D - P(7)*D - P(10)*D*F
C
*     FUNCTION EP
      EP=P(4)*C**2 + P(5)*D - P(8)*E - P11*E*F
C
*     FUNCTION FP
      FP=P(3)*B*C + P(4)*C**2 + P(6)*C - P(10)*D*F - P11*E*F
C
*     FUNCTION GP
      GP=P(6)*C + P(7)*D + P(8)*E
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION A0
      A0=1.0
C
*     FUNCTION INI(I), I IN INDY
      INI(I)=0.0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION AFIT
      AFIT=A
C
*     FUNCTION BFIT
      BFIT=B
C
*     FUNCTION CFIT
      CFIT=C
C
*     FUNCTION DFIT
      DFIT=D
C
*     FUNCTION EFIT
      EFIT=E
C
*     FUNCTION FFIT
      FFIT=F
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

