C
C------------------------------------------------------
C
C     Problem:    PROTEIN
C
C     Date:       15.05.2002
C
C------------------------------------------------------
C
*     REAL CONSTANT
      a1 = 4.75
      a3 = 21.87
C
C------------------------------------------------------
C
*     LININT u
      0.0   0.1
      5.0   0.5
      7.5   1.3
      9.0   2.5
      9.1   0.0
      11.0  0.0
      11.1  0.2
      14.0  0.22
      15.0  2.5
      20.0  2.5
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      b1, b2, b31, b32, z1, z2, z3, z4, z5, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION z1_t
      g3 = a3*z4/((z4 + b31)*(z4 + b32))
      g1 = a1*g3/(b1 + g3)
      g2 = z4*exp(-0.5*z4)/(b2 + z4)
      z1_t = g1*(z2 - z1) - u(t)*z1/z5
C
*     FUNCTION z2_t
      z2_t = g2*z3 - u(t)*z2/z5
C
*     FUNCTION z3_t
      z3_t = g3*z3 - u(t)*z3/z5
C
*     FUNCTION z4_t
      z4_t = -7.3*g3*z3 + u(t)*(20 - z4)/z5
C
*     FUNCTION z5_t
      z5_t = u(t)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION z1_0
      if (t.lt.0.0001) then
        z1_0 = 0
      else
        z1_0 = z1
      endif
C
*     FUNCTION z2_0
      if (t.lt.0.0001) then
        z2_0 = 0
      else
        z2_0 = z2
      endif
C
*     FUNCTION z3_0
      if (t.lt.0.0001) then
        z3_0 = 1
      else
        z3_0 = z3
      endif
C
*     FUNCTION z4_0
      if (t.lt.0.0001) then
        z4_0 = 5
      else
        z4_0 = z4
      endif
C
*     FUNCTION z5_0
      if (t.lt.0.0001) then
        z5_0 = 1      
      else
        z5_0 = z5
      endif
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION z1_fit
      z1_fit = z1
C
*     FUNCTION z2_fit
      z2_fit = z2
C
*     FUNCTION z3_fit
      z3_fit = z3
C
*     FUNCTION z4_fit
      z4_fit = z4
C
*     FUNCTION z5_fit
      z5_fit = z5
C
*     FUNCTION ctrl
      ctrl = u(t)
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
