C
C------------------------------------------------------
C
C     Problem:    PRESSURE
C
C     Date:       15.01.02
C
C------------------------------------------------------
C
*     REAL CONSTANT
      of = 0.44
      scale = 10000
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..3
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables identifying solution of coupled
C        differential algebraic equations, e.g. implicit
C        boundary conditions (w)
C     7. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDAE.
C     8. spatial variable (x)
C     9. time variable (t)
C
*     VARIABLE
      alpha, beta, k, u, o, p, u_x, o_x, p_x, u_xx, o_xx, p_xx
      fu, fo, fp, fu_x, fo_x, fp_x, x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
*     FUNCTION flux_u
      if (o.le.0.55) then
        Ko = o**3/(1 - o)**2
      else
        Ko = 0.8216
      endif
      v = -Ko*p_x
      flux_u = abs(v)*u_x
C
*     FUNCTION flux_o
      flux_o = 0
C
*     FUNCTION flux_p
      flux_p = Ko*p_x
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: differential
C     followed by algebraic functions in first area, then
C     differential followed by algebraic functions in 
C     second area, etc.):
C
*     FUNCTION u_t
      if (o.le.0.55) then
        Ko = o**3/(1 - o)**2
      else
        Ko = 0.8216
      endif   
      g = abs(of - o)*(o*sqrt(abs(1-o)) + (1-o)*sqrt(abs(o)))
      u_t = scale*(alpha*fu_x + Ko*p_x*u_x - k*u*g)
C
*     FUNCTION o_t
      o_t = scale*(beta*u*g)
C
*     FUNCTION equ
      equ = fp_x - beta*u*g
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: initial values for 
C     differential followed by algebraic variables in 
C     first area, then differential followed by algebraic
C     variables in second area, etc.):
C
*     FUNCTION u_0
      u_0 = 0
C
*     FUNCTION o_0
      o_0 = 0.2
C
*     FUNCTION p_0
      p_0 = 0
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
C*     FUNCTION v_t
C      v_t = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
C*     FUNCTION v_0
C      v_0 = ...
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled differential algebraic equations, order 
C     defined by increasing spatial positions (e.g. 
C     implicit boundary conditions):
C
C*     FUNCTION w_t
C      w_t = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled differential
C     algebraic equations for t=0 in the same order:
C
C*     FUNCTION v_0
C      v_0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
*     FUNCTION u_left
      u_left = 1
C
*     FUNCTION p_left
      p_left = 1
C
*     FUNCTION p_right
      p_right = 0
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an area, etc.:
C
*     FUNCTION u_x_right
      u_x_right = 0
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION fit(i), i in ind
      fit(i) = u
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C







