C
C------------------------------------------------------
C
C   Problem:    PORE
C
C   Date:       15.12.2004
C
C------------------------------------------------------
C
*     REAL CONSTANT
      V       = 384
      Q       = 5.3
      Atot    = 648
      epsilon = 0.4
      L       = 0.00004
      Cg1     = 111
C 
C------------------------------------------------------
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE equation, if at all.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      Dss, Dgs, S, kms, km1s, km2s, r
      Cs, Cgpore, Cs_x, Cgpore_x, Cs_xx, Cgpore_xx, Cgbulk, x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C*     FUNCTION flux
C      flux = ...
C
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: differential
C     followed by algebraic functions in first area, then
C     differential followed by algebraic functions in 
C     second area, etc.):
C
*     FUNCTION Cs_t          
      Ds = Dss*1E-10
      Dg = Dgs*1E-10      
      km = kms*1E-10
      Cs_t = Ds*Cs_xx - 2*epsilon*km*(Cs - Cgpore*S)/r/(1 - epsilon)
C
*     FUNCTION Cgpore_t
      Cgpore_t = Dg*Cgpore_xx + 2*km*(Cs - Cgpore*S)/r
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: initial values for 
C     differential followed by algebraic variables in 
C     first area, then differential followed by algebraic
C     variables in second area, etc.):
C
*     FUNCTION Cs_0
      Cs_0 = Cg1*S
C
C     Initital Condition @ t = 0
C
*     FUNCTION Cgpore_0
      Cgpore_0 = Cg1
C
C     Initital Condition @ t = 0
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions::
C
*     FUNCTION Cgbulk_t
      km1 = km1s*1E-10
      km2 = km2s*1E-10
      Cgbulk_t = -Q*Cgbulk/V + (1 - epsilon)*Atot*km1*(Cs - Cgbulk*S)/V
     /           + epsilon*Atot*km2*(Cgpore - Cgbulk)/V
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
*     FUNCTION Cgbulk_0
      Cgbulk_0 = Cg1
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
C*     FUNCTION u_left
C      u_left = 0
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an areas, etc.:
C
C
*     FUNCTION Cs_x_left
      Cs_x_left = 0
C     
*     FUNCTION Cs_x_right
      Ds = Dss*1E-10
      Dg = Dgs*1E-10
      Cs_x_right = km1*(Cgbulk*S - Cs)/Ds
C
*     FUNCTION Cgpore_x_left
      Cgpore_x_left = 0
C
*     FUNCTION Cgpore_x_right
      Cgpore_x_right = km2*(Cgbulk - Cgpore)/Dg
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION fit
      fit = Cgbulk
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
