C
C------------------------------------------------------
C
C     Problem:    POPUL
C
C     Date:       09.01.1995
C
C------------------------------------------------------
C
*     PARAMETER
      N=10
C
C------------------------------------------------------
C
*     SET OF INDICES
      INDN=1..N
C
C------------------------------------------------------
C
*     REAL CONSTANT
      N0=1000.0
      ALPHA1=0.05
      ALPHA2=0.6
      ALPHA3=1.2
      ALPHA4=2.0
      BETA1=0.05
      BETA2=0.3
      BETA3=0.6
      BETA4=1.0
      ALPHA(J)=ALPHA1, J IN INDN
      BETA(J)=BETA1, J IN INDN
      ALPHA(5)=ALPHA2
      ALPHA(6)=ALPHA2
      ALPHA(7)=ALPHA2
      ALPHA(8)=ALPHA2
      ALPHA(9)=ALPHA3
      ALPHA(10)=ALPHA3
      BETA(2)=BETA2
      BETA(6)=BETA2
      BETA(10)=BETA2
      BETA(3)=BETA3
      BETA(7)=BETA3
      BETA(4)=BETA4
      BETA(8)=BETA4
      XMAX=200
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      P0(J), J IN INDN
      X(J), J IN INDN
      T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION XP(J), J IN INDN
      XP(J)=ALPHA(J)*X(J)*(XMAX - X(J)) - BETA(J)*X(J)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION X0(J), J IN INDN
      X0(J)=P0(J)*N0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION FIT
      FIT=SUM(X(J), J IN INDN)
C
C------------------------------------------------------
C
C   - Constraints:
C
*     FUNCTION RESTR
      RESTR=SUM(P0(J), J IN INDN) - 1.0
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C




