C
C------------------------------------------------------
C
C     Problem:    POOL
C
C     Date:       29.09.97
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..9
C
C------------------------------------------------------
C
*     REAL CONSTANT
      alpha = 6.81E+3
      beta = 9.313
      gamma = 0.7717
      delta = 9.4175E-2
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (ux)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (uxx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE equation, if at all.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      a, b, c, u, v, u_x, v_x, u_xx, v_xx, q1, x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C*     FUNCTION FLUX
C      FLUX = ...
C
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u1_t
      if (x.gt.0) then
        u1_t = a*u_xx/(x*alpha)
      else
        u1_t = 0
      endif
C
*     FUNCTION v1_t
      v1_t = a*u_xx
C
*     FUNCTION u2_t
      u2_t = b*(x*u_xx + u_x)/(beta + gamma*log(x))
C
*     FUNCTION v2_t
      v2_t = b*(x*u_xx + u_x)

C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u1_0
      u1_0 = 0
C
*     FUNCTION v1_0
      v1_0 = 0
C
*     FUNCTION u2_0
      u2_0 = 0
C
*     FUNCTION v2_0
      v2_0 = 0
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations:
C
*     FUNCTION q1_t
      q1_t = -c*u_x
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0: 
C
*     FUNCTION q1_0
      q1_0 = 0
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     borders of all areas, then at right borders of all 
C     areas:
C
*     FUNCTION u1_left
      u1_left = 0.038475 
C
*     FUNCTION v1_left
      v1_left = 0
C
*     FUNCTION u1_right
      u1_right = u
C
*     FUNCTION v1_right
      v1_right = v
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left borders of all areas, then
C     at right borders of all areas:
C
*     FUNCTION u2_x_left
      u2_x_left = u_x
C
*     FUNCTION v2_x_left
      v2_x_left = v_x
C
*     FUNCTION u2_x_right
      u2_x_right = 0
C
*     FUNCTION v2_x_right
      v2_x_right = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION q1_fit
      q1_fit = q1
C
*     FUNCTION q2_fit
      q2_fit = delta*(SIMPSN(2,1) + SIMPSN(2,2)) 
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
