C
C------------------------------------------------------
C
C     Problem:    POLYMERI
C
C     Date:       19.06.97
C
C------------------------------------------------------
C
*     REAL CONSTANT
      u01 = 0.001
      u02 = 0.002
      u03 = 0.003
      c1 = 1.0E-5
      c2 = 1.0E-5
      c3 = 1.0E-5
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind9 = 1..9
      ind12 = 1..12
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (ux)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (uxx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE equation, if at all.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      D0, k1, k2, k3, k4, k5, k6, k7, k8
      u1, u2, u3, u4, u5, u6, u7, u8, u9, u10, u11, u12
      u1_x, u2_x, u3_x, u4_x, u5_x, u6_x, u7_x, u8_x, u9_x
            u10_x, u11_x, u12_x
      u1_xx, u2_xx, u3_xx, u4_xx, u5_xx, u6_xx, u7_xx, u8_xx
            u9_xx, u10_xx, u11_xx, u12_xx
      x, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u1_t
      u1_t = D0*u1_xx - 2*k1*u1*(c1*u2 + c2*u3)
C
*     FUNCTION u2_t
      u2_t = D0*u2_xx - 2*c1*k1*u1*u2 - k2*u2*u4 - k3*u2*u5
C
*     FUNCTION u3_t
      u3_t = D0*u3_xx - 2*c2*k1*u1*u3 - k4*u3*u4 - k5*u3*u5
C
*     FUNCTION u4_t
      u4_t = D0*u4_xx + 2*c1*k1*u1*u2 + k3*u2*u5 - k4*u3*u4
     /             - k6*u4*u5 - k7*u4**2
C
*     FUNCTION u5_t
      u5_t = D0*u5_xx + 2*c2*k1*u1*u3 + k4*u3*u4 - k3*u2*u5
     /       - k6*u4*u5 - k8*u5**2
C
*     FUNCTION u6_t
      u6_t = D0*u6_xx + k6*u4*u5 + 0.5*(k7*u4**2 + k8*u5**2)
C
*     FUNCTION u7_t
      u7_t = 2*c1*k1*u1*u2 + k2*u2*u4 - k4*u3*u7 
     /       + k3*u2*(u5 + u9) - k6*u5*u7 - k7*u4*u7
C
*     FUNCTION u8_t
      u8_t =  k3*u2*u10 - k4*u3*u8 - k6*u5*u8 
     /        - k7*u4*u8
C
*     FUNCTION u9_t
      u9_t =  k4*u3*u7 - k5*u2*u9 - k6*u4*u9 
     /        - k8*u5*u9
C
*     FUNCTION u10_t
      u10_t =  2*c2*k1*u1*u3 + k4*u3*(u4 + u8)
     /         + k5*u3*u5 - k3*u2*u10 - k6*u2*u10 - k8*u5*u10
C
*     FUNCTION u11_t
      u11_t =  k7*u4*u7 + k8*u5*u9 + k6*(u5*u7 
     /         + u4*u9)
C
*     FUNCTION u12_t
      u12_t =  k7*u4*u8 + k8*u5*u10 + k6*(u5*u8 
     /         + u4*u10)
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u1_0
      if (x.lt.0) then
        u1_0 = u01
      else
        u1_0 = 0
      endif
C
*     FUNCTION u2_0
      if (x.lt.0) then
        u2_0 = 0
      else
        u2_0 = u02
      endif
C
*     FUNCTION u3_0
      if (x.lt.0) then
        u3_0 = u03
      else
        u3_0 = 0
      endif
C
*     FUNCTION u_0(i), i in ind9
      u_0(i) = 0
C
C------------------------------------------------------
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left borders of all areas, then
C     at right borders of all areas:
C
*     FUNCTION ux_l(i), i in ind12
      ux_l(i) = 0
C
*     FUNCTION ux_r(i), i in ind12
      ux_r(i) = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION u1_fit
      u1_fit = u1
C
*     FUNCTION u2_fit
      u2_fit = u2
C
*     FUNCTION u3_fit
      u3_fit = u3
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
