C
C----------------------------------------------------------------
C
C     Problem:    POLYMER
C
C     Date:       06.11.97
C
C----------------------------------------------------------------
C
*     INTEGER CONSTANT
      M=1
      N=1
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      A, B, C, MT, ST, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION MTP
      if (MT.gt.0) then
        MTP= -A*ST*MT**M
      else
        MTP = 0
      endif
C
*     FUNCTION STP
      if (MT.gt.0) then
        STP = B*(1.0 - ST)*MT**N - C*ST
      else
        STP = 0
      endif
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION MT0
      MT0 = 5.0
C
*     FUNCTION ST0
      ST0 = 0.0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION FIT
      FIT=MT
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


