C
C------------------------------------------------------
C
C     Problem:    POLYBU_X
C
C     Date:       25.9.2000
C
C------------------------------------------------------
C
*     REAL CONSTANT
      V = 29900
      s = 1000
      mw1 = 54
      mwDIBAH = 142.21
      mwEASC = 247.51
      mwND = 658.02
      mws = 78
      alpha = 0.5
      T = 353
      delta_t = 0.05
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      fBi, fDIBAHi, fEASCi, fmsi, fNd3i, time
C
C------------------------------------------------------
C
*     FUNCTION nB_fit
      fmis = fmsi
      nB = 0
      nNd3 = 0
      nDIBAH = 0
      nEASC = 0
      ns = 29900
      act_time = 0
 1000 continue   
      act_time = act_time + delta_t
      kp = 7.024E8*exp(-10332/(1.98*T))
      V0 = 0.97*(fBi/mw1 + fmis/mws)
      fBo = nB*mw1/V*V0
      if (nDIBAH.gt.0) then
        nB_t = (fBi - fBo)*s/mw1 - kp*nB*nNd3*nDIBAH**alpha
      else
        nB_t = (fBi - fBo)*s/mw1 
      endif
      fNd3o = nNd3*mwND/V*V0
      nNd3_t = (fNd3i - fNd3o)/mwND
      fDIBAHo = nDIBAH*mwDIBAH/V*V0
      nDIBAH_t = (fDIBAHi - fDIBAHo)/mwDIBAH
      fEASCo = nEASC*mwEASC/V*V0
      nEASC_t = (fEASCi - fEASCo)/mwEASC
      fmso = ns*mws/V*V0
      ns_t = (fmsi - fmso)/mws
      if (act_time.lt.time) then
        nB = nB + delta_t*nB_t
        nNd3 = nNd3 + delta_t*nNd3_t
        nDIBAH = nDIBAH + delta_t*nDIBAH_t
        nEASC = nEASC + delta_t*nEASC_t
        ns = ns + delta_t*ns_t
        goto 1000
      endif      
      nB_fit = nB
C
*     FUNCTION nNd3_fit
      nNd3_fit = nNd3
C
*     FUNCTION nDIBAH_fit
      nDIBAH_fit = nDIBAH
C
*     FUNCTION nEASC_fit
      nEASC_fit = nEASC
C
*     FUNCTION ns_fit
      ns_fit = ns
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C







