C
C------------------------------------------------------
C
C     Problem:    POLYBU
C
C     Date:       22.9.2000
C
C------------------------------------------------------
C
*     REAL CONSTANT
      V = 29900
      s = 1000
      mw1 = 54
      mwDIBAH = 142.21
      mwEASC = 247.51
      mwND = 658.02
      mws = 78
      alpha = 0.5
      T = 353
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      fBi, fDIBAHi, fEASCi, fmsi, fNd3i
      nB, nNd3, nDIBAH, nEASC, nS, time
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION nB_t
      fmis = fmsi
      kp = 7.024E8*exp(-10332/(1.98*T))
      V0 = 0.97*(fBi/mw1 + fmis/mws)
      fBo = nB*mw1/V*V0
      if (nDIBAH.gt.0) then
        nB_t = (fBi - fBo)*s/mw1 - kp*nB*nNd3*nDIBAH**alpha
      else
        nB_t = (fBi - fBo)*s/mw1 
      endif
C
*     FUNCTION nNd3_t
      fNd3o = nNd3*mwND/V*V0
      nNd3_t = (fNd3i - fNd3o)/mwND
C
*     FUNCTION nDIBAH_t
      fDIBAHo = nDIBAH*mwDIBAH/V*V0
      nDIBAH_t = (fDIBAHi - fDIBAHo)/mwDIBAH
C
*     FUNCTION nEASC_t
      fEASCo = nEASC*mwEASC/V*V0
      nEASC_t = (fEASCi - fEASCo)/mwEASC
C
*     FUNCTION nS_t
      fmso = ns*mws/V*V0
      nS_t = (fmsi - fmso)/mws
C
C------------------------------------------------------
C
C   - Initial values:
C
*     FUNCTION nB_0
      nB_0 = 3456
C
*     FUNCTION nNd3_0
      nNd3_0 = 0
C
*     FUNCTION nDIBAH_0
      nDIBAH_0t = 0
C
*     FUNCTION nEASC_0
      nEASC_0 = 0
C
*     FUNCTION nS_0
      nS_0 = 16876
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION nB_fit
      nB_fit = nB
C
*     FUNCTION nNd3_fit
      nNd3_fit = nNd3
C
*     FUNCTION nDIBAH_fit
      nDIBAH_fit = nDIBAH
C
*     FUNCTION nEASC_fit
      nEASC_fit = nEASC
C
*     FUNCTION nS_fit
      nS_fit = nS
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

