C
C------------------------------------------------------
C
C     Problem:    POLY2
C
C     Date:       4.10.1993
C
C------------------------------------------------------
C
*     REAL CONSTANT
      I0=1.91E-6
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      FI,KI,KTP2,KIS,KT,KTC,KTRD1,KP,R,M1,M2,M,T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION RP
      RP=2.0*FI*I0 - KI*R*M - KTP2*M2*R
C
*     FUNCTION M1P
      M1P=KI*R*M + KIS*M*M2 - 2.0*KT*M1**2 - KTRD1*M*M1
     /    - KTC*M1*M2
C
*     FUNCTION M2P
      M2P=KTRD1*M*M1 - KTP2*M2*R - KIS*M*M2 - KTC*M1*M2
C
*     FUNCTION MP
      MP=-KI*R*M - KP*M*M1 - KTRD1*M*M1 - KIS*M*M2
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION R0
      R0=0.0
C
*     FUNCTION M10
      M10=0.0
C
*     FUNCTION M20
      M20=0.0
C
*     FUNCTION M0
      M0=6.25
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION MFIT
      MFIT=M
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

