C
C------------------------------------------------------
C
C     Problem:    POLY1
C
C     Date:       4.10.1993    
C
C------------------------------------------------------
C
*     REAL CONSTANT
      I0=1.91E-6
      SM1=1.0E-3
      SM2=1.0E-2
      SP=1.0E+5
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      FI,KI,KTP1,KTP2,KPTRD,KPIS,KIS,KT,KTC,KTRD1,
     /   KTRD2,KP,KPTC,KTRM,
     /   R,M1,M2,M3,M,T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION RP
      RP=2.0*FI*I0 - KI*R*M - KPTRD*M*R - KTP1*SP*M1*SM1*R
     /   - KTP2*SP*M2*SM2*R
C
*     FUNCTION M1P
      M1P=KI*R*M/SM1 + KPIS*M*M3/SM1 + KIS*M*M2*SM2/SM1
     /    - 2.0*KT*SP**2*SM1*M1**2 - KTP1*SP*M1*R - KTRD1*M*M1
     /    - KTRD2*M1 - KPTC*SP*M1*M3 - KTC*SP*M1*M2*SM2
C
*     FUNCTION M2P
      M2P=KTRD1*M*M1*SM1/SM2 + KTRD2*M1*SM1/SM2 - KTP2*SP*M2*R
     /    - KIS*M*M2 - KTC*SP*M1*SM1*M2
C
*     FUNCTION M3P
      M3P=KPTRD*M*R - KPIS*M*M3 - KPTC*SP*M1*SM1*M3
C
*     FUNCTION MP
      MP=-KI*R*M - KP*SP*M*M1*SM1 - KTRD1*M*M1*SM1 - KPTRD*M*R
     /    - KPIS*M*M3 - KIS*M*M2*SM2 - KTRM*M1*SM1*M
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION R0
      R0=0.0
C
*     FUNCTION M10
      M10=0.0
C
*     FUNCTION M20
      M20=0.0
C
*     FUNCTION M30
      M30=0.0
C
*     FUNCTION M0
      M0=6.25
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION MFIT
      MFIT=M
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
