C
C------------------------------------------------------
C
C     Problem:    POLLUTNT
C
C     Date:       04.04.2003
C
C------------------------------------------------------
C                     
*     REAL CONSTANT
      C0 = 5883
      S0 = 2350          
      Cs = 5883 
      V = 0.05376 
      theta = 0.7
      So = 2350 
      Q = 0.004786
C
C------------------------------------------------------
C                     
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      a, b, d, e, f, C, S, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION C_t
      C_t = (S/So)**a*b*(Cs - C) - Q/(V*theta)*C + d
C
*     FUNCTION S_t
      S_t = -theta*(S/So)**e*b*(Cs - C) + f
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION C_0
      C_0 = C0
C
*     FUNCTION S_0
      S_0 = S0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION C_fit
      C_fit = C
C
*     FUNCTION S_fit
      S_fit = S
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
