C
C------------------------------------------------------
C
C     Problem:    POLLUTN
C
C     Date:       10.8.1996
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind_bound = 1..8
C
C------------------------------------------------------
C
*     REAL CONSTANT
      D = 1.0E-9
      u0 = 1.3060E-04
      v0 = 1.0765E+02
      w0 = 6.4577E+00
      y0 = 3.5423E+00
      sk1 = 1.0E+5
      sk2 = 1.0E+2
      sk3 = 1.0E-4
      sk4 = 1.0E-3
      sk5 = 1.0E-16
      sk6 = 1.0E-12
      sk7 = 1.0E-15
      sk8 = 1.0E-8
C
C------------------------------------------------------
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (ux)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (uxx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. spatial variable (x)
C     7. time variable (t)
C
*     VARIABLE
c      u0, v0, w0, y0
      k1, k2, k3, k4, k5, k6, k7, k8
      u, v, w, y 
      u_x, v_x, w_x, y_x
      u_xx, v_xx, w_xx, y_xx
      x, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u_t
      u_t = D*u_xx + k1*sk1 - k2*sk2*u + k3*sk3*v + k4*sk4*y
     /      - k5*sk5*u*v - k6*sk6*u*y
C
*     FUNCTION v_t
      v_t = D*v_xx + k2*sk2*u - k3*sk3*v + k5*sk5*u*v 
     /      - k7*sk7*v*w
C
*     FUNCTION w_t
      if ((x.ge.0.475).and.(x.le.0.575)) then
        SST1 = 3250.0
      else
        SST1 = 360.0
      endif
      w_t = D*w_xx - k8*sk8*w + k4*sk4*y + k6*sk6*u*y 
     /     - k7*sk7*v*w + 800.0 + SST1
C
*     FUNCTION y_t
      y_t = D*y_xx - k4*sk4*y + k7*sk7*v*w - k6*sk6*u*y + 800.0
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u_0
      u_0 = u0*1.0E10
C
*     FUNCTION v_0
      v_0 = v0*1.0E10
C
*     FUNCTION w_0
      w_0 = w0*1.0E10
C
*     FUNCTION y_0
      y_0 = y0*1.0E10
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations:
C
C*     FUNCTION VP
C      VP = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0: 
C
C*     FUNCTION V0
C      V0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left borders of all areas, then
C     at right borders of all areas:
C
*     FUNCTION r_x(i), i in ind_bound
      r_x(i) = 0.0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION u_fit
      u_fit = u
C
*     FUNCTION v_fit
      v_fit = v
C
*     FUNCTION w_fit
      w_fit = w
C
*     FUNCTION y_fit
      y_fit = y
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
