C
C------------------------------------------------------
C
C     Problem:    PLUG_FLO
C
C     Date:       14.05.2002
C
C------------------------------------------------------
C
*     CONINT u
      0.0  0.0
      1.9  0.5
      2.5  0.4
      3.2  0.22
      4.5  0.18
C
C------------------------------------------------------
C
*     REAL CONSTANT
      k10 = 1.7536
      k20 = 2.4885
      e1 = 1.1375
      e2 = 2.2748
      r = 1.9872
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      a, b, c, x1, x2, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x1_t
      k1 = k10*1E5*exp(-e1*1E4/(r*x2))
      k2 = k20*1E10*exp(-e2*1E4/(r*x2))
      x1p = (1 - x1)*k1 - x1*k2
      x1_t = x1p
C
*     FUNCTION x2_t
      x2_t = a*x1p - u(t)*(x2 - b)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x1_0
      if (t.lt.0.001) then
        x1_0 = 0
      else
        x1_0 = x1
      endif
C
*     FUNCTION x2_0
      if (t.lt.0.001) then
        x2_0 = c
      else
        x2_0 = x2
      endif
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x1_fit
      x1_fit = x1
C
*     FUNCTION x2_fit
      x2_fit = x2
C
*     FUNCTION ctrl
      ctrl = u(t)
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
