C
C------------------------------------------------------
C
C     Problem:    PLATINUM
C
C     Date:       19.12.2002
C
C------------------------------------------------------
C                           
*     REAL CONSTANT
      K = 0.4
C
C------------------------------------------------------
C                                
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      Q1, Q2, Q3, Q4, Q5, Q6, x, y, s, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x_t 
      z = 1 - x - y - s
      x_t = 2*Q1*z*z - 2*Q5*x*x - Q3*x*y
C
*     FUNCTION y_t
      y_t = Q2*z - Q6*y - Q3*x*y
C
*     FUNCTION s_t 
      s_t = Q4*z - K*Q4*s
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x_0
      x_0 = 0.053805
C
*     FUNCTION y_0
      y_0 = 0.3030344
C
*     FUNCTION s_0
      s_0 = 0.4594
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x_fit
      x_fit = x
C
*     FUNCTION y_fit
      y_fit = y
C
*     FUNCTION s_fit
      s_fit = s
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
