C
C------------------------------------------------------
C
C     Problem:   PLASTER3
C
C     Date:      11.11.1995
C
C------------------------------------------------------
C
*     REAL CONSTANT
      ONE=1.0D+0
      TWO=2.0D+0
      L1=0.05
      L2=0.07
      L3=1.27
      D2=9.34E-4
      D3=39.96
      K23=1.0
      UA=138.0
      D1SC=1.D-6
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. concentration variable, if exists (c)
C     3. Laplace variable (s) corresponding to time
C        variable
C
*     VARIABLE
      D1,K12,AK12,AK13,AK31,S
C
C------------------------------------------------------
C
C   - Functions defining fitting criteria in the Laplace
C     space:
C
*     FUNCTION Y

      P0=UA/S
      P1=DSQRT(S/(D1*D1SC))
      P2=DSQRT(S/D2)
      P3=DSQRT(S/D3)
      WURZ1=DSQRT(D1*D1SC/D2)
      WURZ2=DSQRT(D2/D3)
      FA1=(WURZ2/K23)*DTANH(P3*(L3-L2))
      FA2=(WURZ1/K12)*DTANH(P1*L1)
      W1=P2*(L2-L1)
      SI2=0.5*(1.0-DEXP(-2.0*W1))
      CO2=0.5*(1.0+DEXP(-2.0*W1))
      FA3=(1.0+FA1*FA2)*CO2+(FA1+FA2)*SI2
      FA4=P0/P2*K12*FA2/FA3*DEXP(-W1)
      W2=P3*(L3-L2)
      CO3=0.5*(1.0+DEXP(-2.0*W2))
      Y=500.0*FA4*S/CO3*DEXP(-W2)*(AK31+S)/
     *      (S*S+(AK12+AK13+AK31)*S+AK12*AK31)
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


