C
C--------------------------------------------------------------
C
C     Problem:  CPA
C
C     Date:     11.11.1995
C
C--------------------------------------------------------------
C
*     REAL CONSTANT
      L1=0.055
      L2=0.06
      SCD1=1.0
      FAC=500.0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. concentration variable, if exists (c)
C     3. Laplace variable (s) corresponding to time
C        variable
C
*     VARIABLE
      D1, DA ,K1 ,UA ,S
C
C------------------------------------------------------
C
C   - Functions defining fitting criteria in the Laplace
C     space:
C
*     FUNCTION QS
      P1=DSQRT(S/(D1*SCD1))
      DS=0.5*(D1*SCD1+DA)
      P2=DSQRT(S/DS)
      V1=P1*D1*SCD1*DTANH(P1*L1)/(2.0*K1)
      W=P2*(L2-L1)
      SI=DSINH(W)
      CO=DCOSH(W)
      V2=2.0*V1*SI + P2*DS*CO
      QS=2.0*FAC*V1*K1*UA/(S*P2*V2)*DEXP(-W)
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
