C
C------------------------------------------------------
C
C     Problem:    PLASTER1
C
C     Date:       10.11.1995
C
C------------------------------------------------------
C
*     REAL CONSTANT
      L1 = 0.025
      L2 = 0.065
      L3 = 0.075
      F  = 350.0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. concentration variable, if exists (c)
C     3. Laplace variable (s) corresponding to time
C        variable
C
*     VARIABLE
      D1, D2, D3, CA, CA1, K12, K23, S
C
C------------------------------------------------------
C
C   - Functions defining fitting criteria in the Laplace
C     space:
C
*     FUNCTION Q
      P1   = DSQRT(S/D1)
      P2   = DSQRT(S/D2)
      P3   = DSQRT(S/D3)
      CA2  = K12*CA1
      CAQ  = CA - CA1
      S12  = DSQRT(D2/D1)
      DEF1 = K12*S12*DTANH(P1*L1)
      DEF2 = DEF1/S12 + K12
      DEF3 = DSQRT(D2/D3)/K23*DTANH(P3*(L3 - L2))
      DEF4 = (DEF1*DEF3+1)*DSINH(P2*(L2 - L1))
     /           + (DEF1+DEF3)*DCOSH(P2*(L2 - L1))
      E11  = DEXP(-P1*L1)
      E22  = DEXP(-P2*L2)
      E21  = DEXP(-P2*L1)
      E33  = DEXP(-P3*L3)
      B1   = 0.5*CAQ/S*E11*E22*DEF2*(DEF3 - 1)/DEF4
     /          - 0.5*CA2/S/E21*E22**2*(DEF1 - 1)*(DEF3 - 1)/((DEF3 + 1)*DEF4)
     /          - CA2/S*E22/(DEF3 + 1)
      B2   = 0.5*CAQ/S*E11/E22*DEF2*(DEF3 + 1)/DEF4
     /          - 0.5*CA2/S/E21*(DEF1 - 1)/DEF4
      C2   = -0.5*DSQRT(D2/D3)/E33*(B1/E22 - B2*E22)/DCOSH(P3*(L2 - L3))
      C1   = -C2*E33**2
      A2   = -0.5*P1/P2*(B1/E21 - B2*E21)/DCOSH(P1*L1)
     /          + 0.5*CAQ/(S*DCOSH(P1*L1)*E11)
      A1   = CAQ/S - A2
      Q    = -F*(B1/E22 - B2*E22)/(P2*DCOSH(P3*(L2 - L3)))
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
