C
C------------------------------------------------------
C
C     Problem:    PLASMID
C
C     Date:       14.02.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      S1=60
      P=0.01
      D=0.2
      BETA=1.5
      MARK=0.5
      PER=10
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      U1M, U2M, X1, X2, S, Z1, Z2, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION X1P
      U1=U1M*Z1/(Z1+ 1)
      U2=U2M*Z2/(Z2+1)
      U1S=U1M*S/(S+1)
      U2S=U2M*S/(S+1)
      X1P=U1*X1-D*X1+P*U2*X2
C
*     FUNCTION X2P
      X2P=U2*X2*(1-P)-D*X2
C
*     FUNCTION SP
      TEST=T/PER
      I=0
   20 CONTINUE
      IF (I.GE.TEST) THEN
        GOTO 10
      ENDIF
      I=I+1
      GOTO 20
   10 CONTINUE
      IF (I-TEST.GT.0.5) THEN
        W=MARK-(TEST-I-1)
      ELSE
        W=MARK-(TEST-I)      
      ENDIF
      IF (W.GT.0) THEN
        S0=S1*W
      ELSE
        S0=0
      ENDIF
      SP=D*(S0-S)-U1S*X1-U2S*X2
      R=X2/(X1+X2)
C
*     FUNCTION Z1P
      Z1P=BETA*(S-Z1)
C
*     FUNCTION Z2P
      Z2P=(S-Z2)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION X1_0
      X1_0=0.004
C
*     FUNCTION X2_0
      X2_0=1.176
C
*     FUNCTION S_0
      S_0=0
C
*     FUNCTION Z1_0
      Z1_0=0
C
*     FUNCTION Z2_0
      Z2_0=0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION X1_fit
      X1_fit=X1
C
*     FUNCTION X2_fit
      X2_fit=X2
C
*     FUNCTION S_fit
      S_fit=S
C
*     FUNCTION Z1_fit
      Z1_fit=Z1
C
*     FUNCTION Z2_fit
      Z2_fit=Z2
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G
C      G = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

