C
C------------------------------------------------------
C
C     Problem:    PLANT_GR
C
C     Date:       18.03.1997
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      p0, p1, p2, p3, p4, p5, py0, py1, y0, y1, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION y0p
      y0p = p0*y0*(1 - p2*(y0 + p4*y1))
C
*     FUNCTION y1p
      y1p = p1*y1*(1 - p3*(y1 + p5*y0))
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y00
      if (t.lt.1) then
        y00 = py0
      else
        y00 = 0.9*y0
      endif
C
*     FUNCTION y10
      if (t.lt.1) then
        y10 = py1
      else
        y10 = 0.9*y1
      endif
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION y0fit
      y0fit = y0
C
*     FUNCTION y1fit
      y1fit = y1
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
c*     FUNCTION G(I), I in ind
c      G(I) = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
