C
C------------------------------------------------------
C
C     Problem:    PHOTO_S
C
C     Date:       27.4.1999
C
C------------------------------------------------------
C
*     REAL CONSTANT
      km1 = 1.01E-2
      km2 = 2.81E+1
      kH = 9.92E+3
      kmH = 1.28E+2
      kmE = 4.23
      kP = 1.35E-1
      k0L3 = 2.63E+3
      kS3 = 9.53E+3
      fcl = 5.21E-4
      fop = 2.91E-3
      PQtot = 6
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k1, k2, kE, kmP, k0L0, k0L1, k0L2, kS2, C, N, F0
      y1, y2, y3, y4, y5, y6, y7, y8, y9, y10
      y11, y12, y13, y14, y15, y16, y17, y18, y19, y20
      y21, y22, y23, y24, y25, y26, y27, y28, y29, y30
      y31, y32, y33, y34, y35, y36, y37, y38, y39
      t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION y1_t
C
      B = y2 + y4 + y6 + y8 + y10 + y11 + y14 + y16 + y18
     /    + y19 + y23 + y25 + y27 + y29 + y31 + y32 + y35
     /    + y39
      C0 = (1 + C)/(1 + C*(1 - B))
      kL0 = k0L0*C0
      kL1 = k0L1*C0
      kL2 = k0L2*C0
      kL3 = k0L3*C0
C
      y1_t = -kL1*y1 + kE*y20*y17 - kmE*y1*y21
C
*     FUNCTION y2_t
      y2_t = kL1*y1 - k1*y2 + km1*y3
C
*     FUNCTION y3_t
      y3_t = k1*y2 - km1*y3 - kL2*y3 + k1*y19 - km1*y3
C
*     FUNCTION y4_t
      y4_t = kL2*y3 - k2*y4 + km2*y5
C
*     FUNCTION y5_t
      y5_t = k2*y4 - km2*y5 - kL3*y5 - kH*y5 + kmH*y7
C
*     FUNCTION y6_t
      y6_t = kL3*y5 - kH*y6 + kmH*y8
C
*     FUNCTION y7_t
      y7_t = kH*y5 - kmH*y7 - kL3*y7 - kE*y7*y20 + kmE*y9*y21
C
*     FUNCTION y8_t
      y8_t = kH*y6 - kmH*y8 + kL3*y7 - kE*y8*y20 + kmE*y11*y21
C
*     FUNCTION y9_t
      y9_t = kE*y7*y20 - kmE*y9*y21 - kL3*y9
C
*     FUNCTION y10_t
      y10_t = kL3*y9 - k1*y10 + km1*y12
C
*     FUNCTION y11_t
      y11_t = kE*y8*y20 - kmE*y21*y11 - k1*y11 + km1*y13
C
*     FUNCTION y12_t
      y12_t = k1*y10 - km1*y12 - kS3*y12
C
*     FUNCTION y13_t
      y13_t = kS3*y12 + k1*y11 - km1*y13 - kL0*y13
C
*     FUNCTION y14_t
      y14_t = kL0*y13 - k2*y14 + km2*y15
C
*     FUNCTION y15_t
      y15_t = k2*y14 - km2*y15 - kL1*y15 - kH*y15 + kmH*y17
C
*     FUNCTION y16_t
      y16_t = kL1*y15 - kH*y16 + kmH*y18
C
*     FUNCTION y17_t
      y17_t = kH*y15 - kmH*y17 - kL1*y17 - kE*y20*y17 
     /        + kmE*y1*y21
C
*     FUNCTION y18_t
      y18_t = kH*y16 - kmH*y18 + kL1*y17 - kE*y20*y18 
     /        + kmE*y21*y19 
C
*     FUNCTION y19_t
      y19_t = kE*y20*y18 - kmE*y21*y19 - k1*y19 + km1*y3
C
*     FUNCTION y20_t
      y20_t = -kE*y7*y20 + kmE*y9*y21 - kE*y8*y20 + kmE*y21*y11
     /     - kE*y20*y17 + kmE*y1*y21 - kE*y20*y18 + kmE*y21*y19
     /     + kP*y21 - kmP*y20 - kE*y37*y20 + kmE*y22*y21
     /     - kE*y38*y20 + kmE*y22*y21 - kE*y28*y20 + kmE*y30*y21
     /     - kE*y29*y20 + kmE*y32*y21 - kE*y39*y20 + kmE*y23*y21
     /     + kP*y21 - kmP*y20 
C
*     FUNCTION y21_t
      y21_t = kE*y7*y20 - kmE*y9*y21 + kE*y8*y20 - kmE*y21*y11
     /     + kE*y20*y17 - kmE*y1*y21 + kE*y20*y18 - kmE*y21*y19
     /     - kP*y21 + kmP*y20 + kE*y28*y20 - kmE*y30*y21
     /     + kE*y29*y20 - kmE*y32*y21 + kE*y37*y20 - kmE*y22*y21
     /     + kE*y38*y20 - kmE*y22*y21 + kE*y39*y20 - kmE*y23*y21
     /     - kP*y21 + kmP*y20 
C
*     FUNCTION y22_t
      y22_t = -kL0*y22 + kE*y37*y20 - kmE*y22*y21 + kE*y38*y20
     /        - kmE*y22*y21
C
*     FUNCTION y23_t
      y23_t = kL0*y22 - k1*y23 + km1*y24 + kE*y39*y20 
     /        - kmE*y23*y21
C
*     FUNCTION y24_t
      y24_t = k1*y23 - km1*y24 - kL1*y24
C
*     FUNCTION y25_t
      y25_t = kL1*y24 - k2*y25 + km2*y26
C
*     FUNCTION y26_t
      y26_t = k2*y25 - km2*y26 - kL2*y26 - kH*y26 + kmH*y28
C
*     FUNCTION y27_t
      y27_t = kL2*y26 - kH*y27 + kmH*y29
C
*     FUNCTION y28_t
      y28_t = kH*y26 - kmH*y28 - kL2*y28 - kE*y28*y20
     /       + kmE*y30*y21
C
*     FUNCTION y29_t
      y29_t = kH*y27 - kmH*y29 + kL2*y28 - kE*y29*y20
     /       + kmE*y32*y21
C
*     FUNCTION y30_t
      y30_t = kE*y28*y20 - kmE*y30*y21 - kL2*y30
C
*     FUNCTION y31_t
      y31_t = kL2*y30 - k1*y31 + km1*y33
C
*     FUNCTION y32_t
      y32_t = kE*y29*y20 - kmE*y32*y21 - k1*y32 + km1*y34
C
*     FUNCTION y33_t
      y33_t = k1*y31 - km1*y33 - kS2*y33
C
*     FUNCTION y34_t
      y34_t = kS2*y33 + k1*y32 - km1*y34 - kL3*y34
C
*     FUNCTION y35_t
      y35_t = kL3*y34 - k2*y35 + km2*y36
C
*     FUNCTION y36_t
      y36_t = k2*y35 - km2*y36 - kH*y36 + kmH*y37
C
*     FUNCTION y37_t
      y37_t = kH*y36 - kmH*y37 - kS3*y37 - kE*y37*y20 
     /        + kmE*y22*y21
C
*     FUNCTION y38_t
      y38_t = kS3*y37 - kL0*y38 - kE*y38*y20 + kmE*y22*y21
C
*     FUNCTION y39_t
      y39_t = kL0*y38 - kE*y39*y20 + kmE*y23*y21
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y1_0
      y1_0 = 0.45
C
*     FUNCTION y2_0
      y2_0 = 0
C
*     FUNCTION y3_0
      y3_0 = 0
C
*     FUNCTION y4_0
      y4_0 = 0
C
*     FUNCTION y5_0
      y5_0 = 0
C
*     FUNCTION y6_0
      y6_0 = 0
C
*     FUNCTION y7_0
      y7_0 = 0
C
*     FUNCTION y8_0
      y8_0 = 0
C
*     FUNCTION y9_0
      y9_0 = 0
C
*     FUNCTION y10_0
      y10_0 = 0
C
*     FUNCTION y11_0
      y11_0 = 0
C
*     FUNCTION y12_0
      y12_0 = 0
C
*     FUNCTION y13_0
      y13_0 = 0.1
C
*     FUNCTION y14_0
      y14_0 = 0
C
*     FUNCTION y15_0
      y15_0 = 0
C
*     FUNCTION y16_0
      y16_0 = 0
C
*     FUNCTION y17_0
      y17_0 = 0
C
*     FUNCTION y18_0
      y18_0 = 0
C
*     FUNCTION y19_0
      y19_0 = 0
C
*     FUNCTION y20_0
      y20_0 = 3.3
C
*     FUNCTION y21_0
      y21_0 = 0.1
C
*     FUNCTION y22_0
      y22_0 = 0
C
*     FUNCTION y23_0
      y23_0 = 0
C
*     FUNCTION y24_0
      y24_0 = 0.35
C
*     FUNCTION y25_0
      y25_0 = 0
C
*     FUNCTION y26_0
      y26_0 = 0
C
*     FUNCTION y27_0
      y27_0 = 0
C
*     FUNCTION y28_0
      y28_0 = 0
C
*     FUNCTION y29_0
      y29_0 = 0
C
*     FUNCTION y30_0
      y30_0 = 0
C
*     FUNCTION y31_0
      y31_0 = 0
C
*     FUNCTION y32_0
      y32_0 = 0
C
*     FUNCTION y33_0
      y33_0 = 0
C
*     FUNCTION y34_0
      y34_0 = 0
C
*     FUNCTION y35_0
      y35_0 = 0
C
*     FUNCTION y36_0
      y36_0 = 0
C
*     FUNCTION y37_0
      y37_0 = 0
C
*     FUNCTION y38_0
      y38_0 = 0
C
*     FUNCTION y39_0
      y39_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION F
      Bf = y2 + y4 + y6 + y8 + y10 + y11 + y14 + y16 + y18
     /    + y19 + y23 + y25 + y27 + y29 + y31 + y32 + y35
     /    + y39
      V0 = Bf/(1 + C*(1 - Bf))
      K = Bf/PQtot*(fcl/(1-fcl) - fop/(1-fop)) 
     /    + fop/(PQtot*(1-fop))
      N0 = (N+1)*(1-fop)/(1-fcl) - 1
      V = (V0*N0 + fop - (1-fop)*K*y20)/(N*(1-fop)*(1+K*y20))
      F = F0*(V*N + 1)
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
