C
C------------------------------------------------------
C
C     Problem:    PHOTO_PR
C
C     Date:       21.2.2000
C
C------------------------------------------------------
C
*     REAL CONSTANT
      pi = 3.1415926535
      l = 50*pi/180
      a = 0.15
      i = 5
      r = 0.3
      n = 173
      c = 1
      p = 3
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k, m, z, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION z_t
      d = -23.4*(pi/180)*cos((2*pi/365)*(n+10))
      e = sin(l)*sin(d) + cos(l)*cos(d)*cos((2*pi/24)*(t+12))
      if (e.le.0) then
        s = 0
      else
        s = c*640*e*exp(-a/e)
      endif
      w = (l + m/p*s)/(l + m/p*s*exp(-k*i))
      if (w.le.0) then
        w = 1
      endif
      q = p/k*log(w) - r*i
      z_t = q
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION z_0
      z_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION z_fit
      z_fit = z
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
