C
C------------------------------------------------------
C
C     Problem:    PHOTOCON
C
C     Date:       12.02.2004
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      n0, gamma, delta, k, alpha, Nw, mu, n, nt, p, i, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION n_t
      n_t = -gamma*n*p - delta*n + k*nt
C
*     FUNCTION nt_t
      nt_t = delta*n - k*nt - alpha*nt*p
C
*     FUNCTION p_t
      p_t = -gamma*n*p - alpha*n*nt
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION n_0
      if (i.eq.1) then
        n0i = n0
      else
      if (i.eq.2) then
        n0i = n0*7.94    
      else
        n0i = n0*57.5
      endif
      endif    
      n_0 = n0i
C
*     FUNCTION nt_0
      nt_0 = Nw
C
*     FUNCTION p_0
      p_0 = n0i
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION fit
      if (i.eq.1) then
        n0i = n0
      else
      if (i.eq.2) then
        n0i = n0*7.94    
      else
        n0i = n0*57.5
      endif
      endif        
      fit = mu*p/n0i + (1-mu)/n0i*n
C
*     FUNCTION n_plot
      n_plot = n
C
*     FUNCTION nt_plot
      nt_plot = nt
C
*     FUNCTION p_plot
      p_plot = p
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
