C
C------------------------------------------------------
C
C     Problem:    PHOS_TRA
C
C     Date:       8.3.2000
C
C------------------------------------------------------
C
*     REAL CONSTANT
      y26 = 1
      y27 = 1
      y28 = 1
      y29 = 1
C
C-----------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      y8, y9, y10, y11, y12, y13, y14, y15, y16, y17, y18, 
     /    y19, y20, y21, y22, y23, y24, y25,
     /    y00, y01, y02, y03, y04, y05, y06, y07,
     /    y0, y1, y2, y3, y4, y5, y6, y7,
     /    t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION dy0
      dy0 = y18*y7-y19*y5*y0-(y20*y0-y21*y28)/
     /        (y22+y0/y23+y28/y24)/exp(y25*y27)
C
*     FUNCTION dy1
      dy1 = -y8*y27*y1+y9*y2+y14*y4-y15*y6*y1
C
*     FUNCTION dy2
      dy2 = y8*y27*y1-y9*y2-y10*y2+y11*y3*y29
C
*     FUNCTION dy3
      dy3 = y10*y2-y11*y3*y29-y12*y3*y5+y13*y4
C
*     FUNCTION dy4
      dy4 = y12*y3*y5-y13*y4-y14*y4+y15*y6*y1
C
*     FUNCTION dy5
      dy5 = -y12*y3*y5+y13*y4+y18*y7-y19*y5*y0
C
*     FUNCTION dy6
      dy6 = y14*y4-y15*y6*y1-y16*y6*y26+y17*y7
C
*     FUNCTION dy7
      dy7 = y16*y6*y26-y17*y7-y18*y7+y19*y5*y0
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y0_0
      y0_0 = y00
C
*     FUNCTION y1_0
      y1_0 = y01
C
*     FUNCTION y2_0
      y2_0 = y02
C
*     FUNCTION y3_0
      y3_0 = y03
C
*     FUNCTION y4_0
      y4_0 = y04
C
*     FUNCTION y5_0
      y5_0 = y05
C
*     FUNCTION y6_0
      y6_0 = y06
C
*     FUNCTION y7_0
      y7_0 = y07
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION fit0
      fit0 = y0
C
*     FUNCTION fit1
      fit1 = y1
C
*     FUNCTION fit2
      fit2 = y2
C
*     FUNCTION fit3
      fit3 = y3
C
*     FUNCTION fit4
      fit4 = y4
C
*     FUNCTION fit5
      fit5 = y5
C
*     FUNCTION fit6
      fit6 = y6
C
*     FUNCTION fit7
      fit7 = y7
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


