C
C------------------------------------------------------
C
C     Problem:    PHOSPH_D
C
C     Date:       12.12.1995
C
C------------------------------------------------------
C
*     REAL CONSTANT
      nuB = -1.0
      nuC = 1.0
      k1 = 0.1
      rho = 1000.0
      tz = 30.0
      MA = 261.32
      MB = 122.6
      MC = 383.92
      NAR0 = 3.74
      NBZ0 = 4.0
      mLZ0 = 800.0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      p, q, NBRt, NCRt, mLRt, t     
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION NBRP
      rhot = 1.0
      if (t.ge.tz) then
         rhot = 0.0
      endif
      NAR = NAR0 - NCRt 
      m = NAR*MA + NBRt*MB + NCRt*MC + mLRt 
      NBRP = nuB*k1*rho**(p+q-1.0)*abs(m)**(1.0-p-q)*
     /       abs(NAR)**p*abs(NBRt)**q 
     /       + NBZ0/tz*rhot
C
*     FUNCTION NCRP
      NAR = NAR0 - NCRt 
      m = NAR*MA + NBRt*MB + NCRt*MC + mLRt
      NCRP = nuC*k1*rho**(p+q-1.0)*abs(m)**(1.0-p-q)*
     /       abs(NAR)**p*abs(NBRt)**q 
C
*     FUNCTION mLRP
      rhot=1.0
      if (t.ge.tz) then
         rhot=0.0
      endif
      mLRP = mLZ0/tz*rhot
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION NBR0
      if (t.lt.0.0001) then
        NBR0 = 1.0E-27
      else
        NBR0 = NBRt
      endif        
C
*     FUNCTION NCR0
      if (t.lt.0.0001) then
        NCR0 = 0.0
      else
        NCR0 = NCRt
      endif
C
*     FUNCTION mLR0
      if (t.lt.0.0001) then
        mLR0 = 1.0E-27
      else
        mLR0 = mLRt
      endif
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION NBR_FIT
      NBR_FIT = NBRt
C
*     FUNCTION NCR_FIT
      NCR_FIT = NCRt
C
*     FUNCTION mLR_FIT
      mLR_FIT = mLRt
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
