C
C------------------------------------------------------
C
C     Problem:    PHOSPH_A
C
C     Date:       15.12.1995
C
C------------------------------------------------------
C
*     REAL CONSTANT
      nuB = -1.0
      nuC = 1.0
      p = 1.0
      q = 1.0
      k1 = 0.1
      rho = 1000.0
      tz = 15.0
      MA = 261.32
      MB = 122.6
      MC = 383.92
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. variables identifying solution of corresponding
C        algebraic equations (z)
C     4. concentration variable, if exists (c)
C     5. time variable (t)
C
*     VARIABLE
      NAR0, NBZ0, mLZ0, NBRt, NCRt, mLRt, mt, NAt, t     
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION NBRP
      e = p + q - 1
      rhot = 1.0
      if (t.ge.tz) then
         rhot = 0.0
      endif
      NBRP = nuB*k1*rho**e/mt**e*NAt**p*NBRt**q 
     /       + NBZ0/tz*rhot
C
*     FUNCTION NCRP
      NCRP = nuC*k1*rho**e/mt**e*NAt**p*NBRt**q 
C
*     FUNCTION mLRP
      rhot=1.0
      if (t.ge.tz) then
         rhot=0.0
      endif
      mLRP = mLZ0/tz*rhot
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     algebraic equations:
C
*     FUNCTION mP
      mP = NAt*MA + NBRt*MB + NCRt*MC + mLRt - mt
C
*     FUNCTION NAP
      NAP = NAR0 - NCRt - NAt 
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION NBR0
      if (t.lt.1) then
        NBR0 = 0.00000001
      else
        NBR0 = NBRt
      endif
C
*     FUNCTION NCR0
      if (t.lt.1) then
        NCR0 = 0.0
      else
        NCR0 = NCRt
      endif
C
*     FUNCTION mLR0
      if (t.lt.1) then
        mLR0 = 764.0
      else
        mLR0 = mLRt
      endif
C
C------------------------------------------------------
C
C   - Initial values for solving systems of algebraic
C     equations (t=0):
C
*     FUNCTION m0
      m0 = NAR0*MA + 0.00000001*MB + 764.0
C
*     FUNCTION NA0
      NA0 = NAR0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION NBR_FIT
      NBR_FIT = NBRt
C
*     FUNCTION NCR_FIT
      NCR_FIT = NCRt
C
*     FUNCTION mLR_FIT
      mLR_FIT = mLRt
C
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

