C
C------------------------------------------------------
C
C     Problem:    PHB
C
C     Date:       02.07.98
C
C------------------------------------------------------
C
*     REAL CONSTANT
      YRS = 1.5
      UM1 = 0.13
      KS1 = 0.1
      UM2 = 0.08
      KS2 = 1
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      YPR, KIN, K1, K2, R, S, P, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION RA
      Z=S/KS2
      ZN=Z*Z*Z*Z*Z
      U1=UM1*S/(KS1+S)
      U2=UM2*ZN/(1+ZN)
      U=U1+U2
      RR=U*R
      RA=RR
C
*     FUNCTION SA
      RS=-RR/YRS
      SA=RS
C
*     FUNCTION PA
      RP1=RR*YPR
      RP2=R*KIN*(-K1*P+K2*R)/(KIN+S)
      RP=RP1+RP2
      PA=RP
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION R0
      R0=0.22
C
*     FUNCTION S0
      S0=2.3
C
*     FUNCTION P0
      P0=0.22
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION XFIT
      XFIT=R+P
C
*     FUNCTION SFIT
      SFIT=S
C
*     FUNCTION PFIT
      PFIT=P
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
