C
C------------------------------------------------------
C
C     Problem:    PHA_REAC
C
C     Date:       7.5.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      S0=1
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      kp, k1p, k1m, E0, tau, PR, ES, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION PRp
      if (t.ge.tau) then
        PRp = kp*ES
      else
        PRp = 0
      endif
C
C------------------------------------------------------
C
*     FUNCTION ESp
      if (t.ge.tau) then
        ESp = k1p*(E0-ES)*(S0-ES)-(k1m+kp)*ES
       else
        ESp = 0
      endif
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION PR0
      PR0 = 0
C
*     FUNCTION ES0
      ES0 = 0
C
C------------------------------------------------------
C
C   - Fitting criterion:
C
*     FUNCTION FIT1
      FIT1 = PR
C
*     FUNCTION FIT2
      FIT2 = ES
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C



