C
C------------------------------------------------------
C
C     Problem:    PHA_KIN2
C
C     Date:       26.02.98
C
C------------------------------------------------------
C
*     REAL CONSTANT
      eps = 0.0000001
      D = 200
      tau1=0.1
      tau2=2
      tau3=6
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k14, k24, k34, k45, k56, k57
      a1, a2, a3
      y1, y2, y3, y4, y5, y6, y7, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION y1_t
      y1_t = -k14*y1
C
*     FUNCTION y2_t
      y2_t = -k24*y2
C
*     FUNCTION y3_t
      y3_t = -k34*y3
C
*     FUNCTION y4_t
      y4_t = k14*y1 + k24*y2 + k34*y3 - k45*y4
C
*     FUNCTION y5_t
      y5_t = k45*y4 - (k56 + k57)*y5
C
*     FUNCTION y6_t
      y6_t = k56*y5
C
*     FUNCTION y7_t
      y7_t = k57*y5
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y1_0
      if (t.lt.eps) then
        y1_0 = 0
      else
      if (t.lt.tau1+eps) then
        y1_0 = D*a1
      else
        y1_0 = y1
      endif
      endif
C
*     FUNCTION y2_0
      if (t.lt.tau1+eps) then
        y2_0 = 0
      else
      if (t.lt.tau2+eps) then
        y2_0 = D*a2
      else
        y2_0 = y2
      endif
      endif
C
*     FUNCTION y3_0
      if (t.lt.tau2+eps) then
        y3_0 = 0
      else
        y3_0 = D*a3
      endif
C
*     FUNCTION y4_0
      if (t.lt.tau1+eps) then
        y4_0 = 0
      else
        y4_0 = y4
      endif
C
*     FUNCTION y5_0
      if (t.lt.tau1+eps) then
        y5_0 = 0
      else
        y5_0 = y5
      endif
C
*     FUNCTION y6_0
      if (t.lt.tau1+eps) then
        y6_0 = 0
      else
        y6_0 = y6
      endif
C
*     FUNCTION y7_0
      if (t.lt.tau1+eps) then
        y7_0 = 0
      else
        y7_0 = y7
      endif
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION y5_fit
      y5_fit = y5
C
*     FUNCTION y6_fit
      y6_fit = y6
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
*     FUNCTION e
      e = 1 - a1 - a2 - a3
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

