C
C------------------------------------------------------
C
C     Problem:    PHA_KIN1
C
C     Date:       24.6.1999
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      D, b1, b2, k12, k13, k21, y1, y2, y3, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION y1_t
      y1_t = -(k12 + k13)*y1 + k21*y2
C
*     FUNCTION y2_t
      y2_t = k12*y1 - k21*y2
C
*     FUNCTION y3_t
      y3_t = k13*y1
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y1_0
      y1_0 = D
C
*     FUNCTION y2_0
      y2_0 = 0
C
*     FUNCTION y3_0
      y3_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION y3_fit
      y3_fit = y3
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
*     FUNCTION g1
      g1 = b1*b2 - k13*k21
C
*     FUNCTION g2
      g2 = b1 + b2 + k12 + k13 + k21
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
