C
C------------------------------------------------------
C
C     Problem:  PHA_DYN5
C
C     Date:     5.3.2001      
C
C------------------------------------------------------
C
*     REAL CONSTANT
      S0 = 1
      I0 = 0.01
C
C------------------------------------------------------
C
*     VARIABLE
      kp, k1p, k1m, E0, k2p, k2m, tau, PR, ES, EI, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION PRp
      if (t.ge.tau) then
        PRp = kp*ES
      else
        PRp = 0
      endif
C
C------------------------------------------------------
C
*     FUNCTION ESp
      if (t.ge.tau) then
        ESp = k1p*(E0-ES-EI)*(S0-ES)-(k1m+kp)*ES
      else
        ESp = 0
      endif
C
C------------------------------------------------------
C
*     FUNCTION EIp
      if (t.ge.tau) then
        EIp = k2p*(E0-ES-EI)*(I0-EI)-k2m*EI
      else
        EIp = 0
      endif
C
C------------------------------------------------------
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION PR0
      PR0 = 0
C
*     FUNCTION ES0
      ES0 = 0
C
*     FUNCTION EI0
      EI0 = 0
C
C------------------------------------------------------
C
C   - Fitting criterion:
C
*     FUNCTION FIT1
      FIT1 = PR
C
*     FUNCTION FIT2
      FIT2 = ES
C
*     FUNCTION FIT3
      FIT3 = EI
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
