C
C------------------------------------------------------
C
C     Problem:  PHA_DYN3
C
C     Date:     5.3.2001      
C
C------------------------------------------------------
C
*     REAL CONSTANT
      S0 = 1
      E0 = 0.5
      k1m = 10
C
C------------------------------------------------------
C
*     VARIABLE
      kp, k1p, k2p, k2m
      PR, ES, EI, I0, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION PRp
      PRp=kp*ES
C
*     FUNCTION ESp
      ESp=k1p*(E0-ES-EI)*(S0-ES)-(k1m+kp)*ES
C
*     FUNCTION EIp
      EIp=k2p*(E0-ES-EI)*(I0-EI)-k2m*EI
C
C------------------------------------------------------
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION PR0
      PR0=0
C
*     FUNCTION ES0
      ES0=0
C
*     FUNCTION EI0
      EI0=0
C
C------------------------------------------------------
C
C   - Fitting criterion:
C
*     FUNCTION FIT1
      FIT1=PR
C
*     FUNCTION FIT2
      FIT2=ES
C
*     FUNCTION FIT3
      FIT3=EI
C
*     END
C
C------------------------------------------------------
C






