C
C------------------------------------------------------
C
C     Problem:  PHA_DYN2
C
C     Date:     5.3.2001      
C
C------------------------------------------------------
C
*     REAL CONSTANT
      S0 = 1
      E0 = 0.5
      k1m = 10
C
C------------------------------------------------------
C
*     VARIABLE
      kp, k1p, k2p, k2m
      PR01, PR02, PR03, PR04, PR05
      ES01, ES02, ES03, ES04, ES05
      EI01, EI02, EI03, EI04, EI05
      PR, ES, EI, I0, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION PRp
      PRp = kp*ES
C
*     FUNCTION ESp
      ESp = k1p*(E0-ES-EI)*(S0-ES)-(k1m+kp)*ES
C
*     FUNCTION EIp
      EIp = k2p*(E0-ES-EI)*(I0-EI)-k2m*EI
C
C------------------------------------------------------
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION PR0
      if (I0.lt.0.1) then 
        PR0 = PR01
      else
      if (I0.lt.0.3) then 
        PR0 = PR02
      else
      if (I0.lt.0.6) then 
        PR0 = PR03
      else
      if (I0.lt.0.8) then 
        PR0 = PR04
      else
        PR0 = PR05
      endif
      endif
      endif
      endif
C
*     FUNCTION ES0
      if (I0.lt.0.1) then 
        ES0 = ES01
      else
      if (I0.lt.0.3) then 
        ES0 = ES02
      else
      if (I0.lt.0.6) then 
        ES0 = ES03
      else
      if (I0.lt.0.8) then 
        ES0 = ES04
      else
        ES0 = ES05
      endif
      endif
      endif
      endif
C
*     FUNCTION EI0
      if (I0.lt.0.1) then 
        EI0 = EI01
      else
      if (I0.lt.0.3) then 
        EI0 = EI02
      else
      if (I0.lt.0.6) then 
        EI0 = EI03
      else
      if (I0.lt.0.8) then 
        EI0 = EI04
      else
        EI0 = EI05
      endif
      endif
      endif
      endif
C
C------------------------------------------------------
C
C   - Fitting criterion:
C
*     FUNCTION FIT1
      FIT1 = PR
C
*     FUNCTION FIT2
      FIT2 = ES
C
*     FUNCTION FIT3
      FIT3 = EI
C
*     END
C
C------------------------------------------------------
C






