C
C------------------------------------------------------
C
C     Problem:  PHA_DYN1
C
C     Date:     5.3.2001      
C
C------------------------------------------------------
C
*     REAL CONSTANT
      S0 = 1
      E0 = 0.5
      k1m = 10
C
C------------------------------------------------------
C
*     VARIABLE
      kp, k1p, k2p, k2m
      tau1, tau2, tau3, tau4, tau5
      PR, ES, EI, I0, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION PRp
      if (I0.lt.0.1) then 
        tau = tau1
      else
      if (I0.lt.0.3) then 
        tau = tau2
      else
      if (I0.lt.0.6) then 
        tau = tau3
      else
      if (I0.lt.0.8) then 
        tau = tau4
      else
        tau = tau5
      endif
      endif
      endif
      endif
      if (t.ge.tau) then
        PRp = kp*ES
      else
        PRp = 0
      endif
C
*     FUNCTION ESp
      if (t.ge.tau) then
        ESp = k1p*(E0-ES-EI)*(S0-ES) - (k1m+kp)*ES
      else
        ESp = 0
      endif
C
*     FUNCTION EIp
      if (t.ge.tau) then
        EIp = k2p*(E0-ES-EI)*(I0-EI) - k2m*EI
      else
        EIp = 0
      endif
C
C------------------------------------------------------
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION PR0
      PR0 = 0
C
*     FUNCTION ES0
      ES0 = 0
C
*     FUNCTION EI0
      EI0 = 0
C
C------------------------------------------------------
C
C   - Fitting criterion:
C
*     FUNCTION FIT1
      FIT1 = PR
C
*     FUNCTION FIT2
      FIT2 = ES
C
*     FUNCTION FIT3
      FIT3 = EI
C
*     END
C
C------------------------------------------------------
C


