C
C------------------------------------------------------
C
C   Problem:     PHARM_AP
C
C   Date:        13.02.03
C
C------------------------------------------------------
C
*     REAL CONSTANT
      rk = 0.01
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. system variables (y)
C     3. time variable (t)
C
*     VARIABLE
      N, s0, sigma, ro
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     nonlinear equations:
C
*     FUNCTION s
      rstrich = SQRT(sigma/(N*3.14))
      rdach = (rk - rstrich)
      h = rstrich*3.14/6
      r = rk*3.14/(6*(ro + 0.00001))
      a = rdach/r
      IF ((a.GE.-1).AND.(a.LE.1)) THEN
        s= - 4/3*3.14*rk**3 
     /     + 2*3.14*r*(2/3*r**2*(1 - 0.5*h*a**2/r - h/r)
     /     + r*rstrich*(3.14/2 - ACOS(a) - h*a/r) 
     /                       + rstrich**2*(1 - h/r))
     /     + 2*h*(rdach**2*3.14 + 8*rdach*rstrich + 4*rstrich**2)
      ELSE
        s = 0
      ENDIF
C
C------------------------------------------------------
C
C   - Initial values for solving systems of nonlinear
C     equations:
C
*     FUNCTION s_0
      s_0 = s0
C
C
C------------------------------------------------------
C
C   - Fitting criterion:
C
*     FUNCTION fit
      fit = sigma
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
