C
C------------------------------------------------------
C
C     Problem:    PHARMA
C
C     Date:       22.11.97
C
C------------------------------------------------------
C
*     REAL CONSTANT
      d0 = 0
      dose = 48.15
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k1, k2, kd, km, kc, vb, vs, vm, et, d, s, m, a, b, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION d_t
      if (t.lt.et) then
        i = dose/et
      else
        i = 0
      endif
      d_t = (i - (k1 + kd + kc)*d + k2*s)/vb
C
*     FUNCTION s_t
      s_t = (k1*d - k2*s)/vs
C
*     FUNCTION m_t
      m_t = (kc*d - km*m)/vm
C
*     FUNCTION a_t
      a_t = kd*d 
C
*     FUNCTION b_t
      b_t = km*m 
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION d_0
      if (t.lt.0.00001) then
        d_0 = d0 
      else
        d_0 = d
      endif
C
*     FUNCTION s_0
      if (t.lt.0.00001) then
        s_0 = 0 
      else
        s_0 = s
      endif
C
*     FUNCTION m_0
      if (t.lt.0.00001) then
        m_0 = 0 
      else
        m_0 = m
      endif
C
*     FUNCTION a_0
      if (t.lt.0.00001) then
        a_0 = 0 
      else
        a_0 = a
      endif
C
*     FUNCTION b_0
      if (t.lt.0.00001) then
        a_0 = 0 
      else
        a_0 = a
      endif
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION d_fit
      d_fit = d
C
*     FUNCTION m_fit
      m_fit = m
C
*     FUNCTION a_fit
      a_fit = a
C
*     FUNCTION b_fit
      b_fit = b
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

