C
C------------------------------------------------------
C
C     Problem:    PERIOCHP
C
C     Date:       03.06.2005
C
C------------------------------------------------------
C
*     REAL CONSTANT
      E0    = 1.0E-5
      KM    = 0.04
      Ki    = 0.001967
      beta  = 20.32
      ka    = 1.045E4
      kd    = 0.07816
      K     = 1.337E5
      Cload = 0.28    
      rho0  = 0.045        
      L     = 0.02
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations(u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (One
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE.)
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      D, Bmax, kcat
      C, rho, Q, C_x, rho_x, Q_x, C_xx, rho_xx, Q_xx
      x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C*     FUNCTION flux
C      flux = ...
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: all 
C     functions in first area, then all functions in
C     second area, etc.):
C
*     FUNCTION C_t                         
      drho = -kcat*E0*rho/(KM + rho*(1 + beta*Bmax*Q)) 
      dQ = ka*(1 - Q)*C - kd*Q
      C_t = D*C_xx - rho*Bmax*dQ - Q*Bmax*drho
C
*     FUNCTION rho_t                         
      rho_t = drho
C
*     FUNCTION Q_t                         
      Q_t = dQ
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: all initial values in 
C     first area, then all initial values in second 
C     area, etc.):
C
*     FUNCTION C_0
      w = (1 + rho0*Bmax*K - Cload*K)/K
      C0 = -0.5*w + sqrt(0.25*w**2 + Cload/K)
      C_0 = C0
C
*     FUNCTION rho_0
      rho_0 = rho0
C
*     FUNCTION Q_0
      Q_0 = K*C0/(1 + K*C0)
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
C*     FUNCTION v_t
C      v_t = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
C*     FUNCTION v_0
C      v_0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
*     FUNCTION C_right
      C_right = 0
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an area, etc.:
C
*     FUNCTION C_x_left
      C_x_left = 0
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION fit
      w = (1 + rho0*Bmax*K - Cload*K)/K
      C0 = -0.5*w + sqrt(0.25*w**2 + Cload/K)
      Q0 = K*C0/(1 + K*C0)
      fit = 1 - (SIMPSN(1,1) + Bmax*Q0*SIMPSN(2,1))/(L*Cload)
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
