C
C--------------------------------------------------------------
C
C     Problem:   PERIA
C
C     Date:      13.12.95
C
C--------------------------------------------------------------
C
*     REAL CONSTANT
      sc = 1.0E+3
      wm = 3.1415926535897/180
      i  = 46.573738
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. system variables (z)
C     3. time variable (t)
C
*     VARIABLE
      n, a, ex, w, TD, EA, v, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     nonlinear equations:
C
*     FUNCTION G1
      G1 = sc*(n*wm*(TD - t) - EA + ex*sin(EA))
C
*     FUNCTION G2
      G2 = sc*(tan(0.5*v) - sqrt((1+ex)/(1-ex))*tan(0.5*EA))
C
C------------------------------------------------------
C
C   - Initial values for solving systems of nonlinear
C     equations:
C
*     FUNCTION Z101
      Z10 = 0
C
*     FUNCTION Z20
      Z20 = 0.01
C
C------------------------------------------------------
C
C   - Fitting criterion:
C
*     FUNCTION VZ
      AS = a*sin(i*wm)
      VZ= n*wm*AS/(1.0 - ex**2) * (sin(w*wm+v) + ex*sin(w*wm))
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
