C
C------------------------------------------------------
C
C     Problem:    PENICILL
C
C     Date:       15.05.2002
C
C------------------------------------------------------
C
*     REAL CONSTANT
      V = 500
C
C------------------------------------------------------
C
*     CONINT u
      0.0    11.37
      12.6   33.69
      25.2    8.46
      37.8    8.78
      50.4    9.20
      63.0    9.18
      75.6    9.42
      88.2    9.58
      100.8   9.63
      113.4   9.71
      126.0   9.71
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      a, b, c, d, x1, x2, x3, x4, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x1_t
      h1 = 0.11*x3/(0.006*x1 + x3)
      h2 = 0.0055*x3/(0.0001 + x3*(1 + 10*x3))
      x1_t = h1*x1 - u(t)*x1/x4/V
C
*     FUNCTION x2_t
      x2_t = h2*x1 - a*x2 - u(t)*x2/x4/V
C
*     FUNCTION x3_t
      x3_t = -h1*x1/b - h2*x2/c - d*x1*x3/(0.0001 + x3)
     /            + u(t)*(1 - x3/V)/x4
C
*     FUNCTION x4_t
      x4_t = u(t)/V
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x1_0
      if (t.lt.0.001) then
        x1_0 = 1.5
      else
        x1_0 = x1
      endif
C
*     FUNCTION x2_0
      if (t.lt.0.001) then
        x2_0 = 0
      else
        x2_0 = x2
      endif
C
*     FUNCTION x3_0
      if (t.lt.0.001) then
        x3_0 = 0
      else
        x3_0 = x3
      endif
C
*     FUNCTION x4_0
      if (t.lt.0.001) then
        x4_0 = 7
      else
        x4_0 = x4
      endif
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x1_fit
      x1_fit = x1
C
*     FUNCTION x2_fit
      x2_fit = x2
C
*     FUNCTION x3_fit
      x3_fit = x3
C
*     FUNCTION x4_fit
      x4_fit = x4
C
*     FUNCTION ctrl
      ctrl = u(t)
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C








