C
C------------------------------------------------------
C
C     Problem:    PEND_ELA
C
C     Date:       17.10.99
C
C------------------------------------------------------
C
*     REAL CONSTANT
      g = 9.81
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      eps, p1, p2, v1, v2, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION p1_t
      p1_t = v1
C
*     FUNCTION p2_t
      p2_t = v2
C
*     FUNCTION v1_t
      l = sqrt(p1**2 + p2**2)
      eps1 = eps*1E-6
      v1_t = -p1/l/eps1*(l - 1)
C
*     FUNCTION v2_t
      v2_t = -p2/l/eps1*(l - 1) - g
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION p1_0
      p1_0 = 1
C
*     FUNCTION p2_0
      p2_0 = 0
C
*     FUNCTION v1_0
      v1_0 = 0
C
*     FUNCTION v2_0
      v2_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION fit
      fit = 1 - (p1**2 + p2**2)
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
