C
C     Problem:    PENDU_IV
C
C     Date:       13.5.1997
C
C------------------------------------------------------
C
*     REAL CONSTANT
      p10 = -10000.0
      p20 = -10000.0
      v10 = 1
      v20 = -1
      q10 = 1
      q20 = 1
      tau0 = 10000.0 
      g = 10
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. variables identifying solution of corresponding
C        algebraic equations (z)
C     4. concentration variable, if exists (c)
C     5. time variable (t)
C
*     VARIABLE
      m, l, q1, q2, v1, v2, p1, p2, tau, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION q1_p
      pqr = p1**2 + p2**2
      w1 = v1 - (p1**2*v1 + p1*p2*v2)/pqr
      q1_p = w1 + 2*tau/m*w1
C
*     FUNCTION q2_p
      w2 = v2 - (p1*p2*v1 + p2**2*v2)/pqr
      q2_p = w2 + 2*tau/m*w2
C
*     FUNCTION v1_p 
      wqr = w1**2 + w2**2
      term1 = (-g*p2 + wqr)/pqr
      term2 = (p1*v1 + p2*v2)/pqr
      v1_p = -term1*p1 + term2*w1
C
*     FUNCTION v2_p 
      v2_p = -g - term1*p2 + term2*w2
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     algebraic equations:
C
*     FUNCTION constraint1
      constraint1 = p1 - q1 + 2*tau*p1/m
C
*     FUNCTION constraint2
      constraint2 = p2 - q2 + 2*tau*p2/m
C
*     FUNCTION constraint3
      constraint3 = p1**2 + p2**2 - l**2
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION q1_0
      q1_0 = q10
C
*     FUNCTION q2_0
      q2_0 = q20
C
*     FUNCTION v1_0
      v1_0 = v10
C
*     FUNCTION v2_0
      v2_0 = v20
C
C------------------------------------------------------
C
C   - Initial values for solving systems of algebraic
C     equations (t=0):
C
*     FUNCTION p1_0
      p1_0 = p10
C
*     FUNCTION p2_0
      p2_0 = p20
C
*     FUNCTION tau_0
      tau_0 = tau0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION p1_fit
      p1_fit = p1
C
*     FUNCTION p2_fit
      p2_fit = p2
C
*     FUNCTION v1_fit
      v1_fit = v1
C
*     FUNCTION v2_fit
      v2_fit = v2
C
*     FUNCTION lambda
      wqr = w1**2 + w2**2
      pqr = p1**2 + p2**2
      lambda = m*(-g*p2 + wqr)/(2*pqr)
C
*     FUNCTION I1_equation
      I1_equation = p1**2 + p2**2 - l**2
C
*     FUNCTION I2_equation
      pqr = p1**2 + p2**2
      w1 = v1 - (p1**2*v1 + p1*p2*v2)/pqr
      w2 = v2 - (p1*p2*v1 + p2**2*v2)/pqr
      I2_equation = p1*w1 + p2*w2
C
*     FUNCTION I3_equation
      I3_equation = w1**2 + w2**2 - g*p2 
     /         - 2*lambda*(p1**2 + p2**2)/m
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C






