C
C     Problem:    PENDU_I2
C
C     Date:       13.5.1997
C
C------------------------------------------------------
C
*     REAL CONSTANT
      p10 = -0.7
      v10 = 1 
      g = 10
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. variables identifying solution of corresponding
C        algebraic equations (z)
C     4. concentration variable, if exists (c)
C     5. time variable (t)
C
*     VARIABLE
      m, l, p1, p2, v1, v2, lambda, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION p1_p
      p1_p = v1 
C
*     FUNCTION p2_p
      p2_p = v2 
C
*     FUNCTION v1_p 
      v1_p = -2*p1*lambda/m
C
*     FUNCTION v2_p 
      v2_p = (-m*g -2*p2*lambda)/m
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     algebraic equations:
C
*     FUNCTION constraint
      constraint = p1*v1 + p2*v2
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION p1_0
      p1_0 = p10
C
*     FUNCTION p2_0
      p20 = -sqrt(l**2 - p10**2)
      p2_0 = p20
C
*     FUNCTION v1_0
      v1_0 = v10
C
*     FUNCTION v2_0
      p20 = -sqrt(l**2 - p10**2)
      v20 = -p10*v10/p20
      v2_0 = v20
C
C------------------------------------------------------
C
C   - Initial values for solving systems of algebraic
C     equations (t=0):
C
*     FUNCTION lambda_0
      p20 = -sqrt(l**2 - p10**2)
      v20 = -p10*v10/p20
      lambda_0 = (v10**2 + v20**2 - g*p20)*m/
     /                       (2*(p10**2 + p20**2))
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION p1_fit
      p1_fit = p1
C
*     FUNCTION p2_fit
      p2_fit = p2
C
*     FUNCTION v1_fit
      v1_fit = v1
C
*     FUNCTION v2_fit
      v2_fit = v2
C
*     FUNCTION I1_equation
      I1_equation = p1**2 + p2**2 - l**2
C
*     FUNCTION I2_equation
      I2_equation = p1*v1 + p2*v2
C
*     FUNCTION I3_equation
      I3_equation = v1**2 + v2**2 - g*p2 
     /         - 2*lambda*(p1**2 + p2**2)/m
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C







